# ESPN Fantasy Data Scraper

Simple browser extension to scrape your ESPN Fantasy Basketball league configuration.

## Installation

### Chrome
1. Download `espn-fantasy-scraper.zip`
2. Extract the ZIP file
3. Go to `chrome://extensions/`
4. Enable "Developer mode" (top right)
5. Click "Load unpacked"
6. Select the extracted folder

### Firefox
1. Download `espn-fantasy-scraper.zip`
2. Extract the ZIP file
3. Go to `about:debugging#/runtime/this-firefox`
4. Click "Load Temporary Add-on"
5. Select `manifest.json` from the extracted folder

## Usage

1. **Visit** your ESPN Fantasy Basketball league page
   - URL: `https://fantasy.espn.com/basketball/league?leagueId=YOUR_LEAGUE`
2. **Click** the extension icon 🏀
3. **Click** "Scrape Current Page"
4. **Click** "Copy to Clipboard"
5. **Paste** the data into your fantasy helper app

## What Gets Scraped?

```json
{
  "leagueId": "939370760",
  "swid": "{YOUR-SWID}",
  "espn_s2": "YOUR_ESPN_S2_COOKIE"
}
```

- **League ID**: From the URL
- **SWID**: Authentication cookie
- **ESPN_S2**: Session cookie

## Privacy

- ✅ All data stays on your computer
- ✅ Nothing is sent to any servers
- ✅ Only works on ESPN Fantasy pages
- ✅ Open source - inspect the code yourself

## Troubleshooting

**"Please navigate to ESPN Fantasy Basketball page first"**
- Make sure you're on `fantasy.espn.com/basketball/league`
- The URL must include your league ID

**"Please refresh the ESPN page and try again"**
- Refresh the ESPN page (F5)
- Try scraping again

**Extension not working?**
- Make sure you're logged into ESPN
- Check that you're on the correct league page
- Try reinstalling the extension
